#include "stdafx.h"
#include "common.h"
#include "tree.h"
#include "emit.h"
#include "error.h"
#include <stdio.h>
#include "scriptHeaders.h"
#include "opcodes.h"
#include "asmutils.h"


//****************************************************************************************************************
//vypise do souboru navesti
//****************************************************************************************************************
void CEmit::processLabel(int label)
{
	fprintf(m_assemblyFile,"%s_%i",m_CurrLabels[label].name,label);
}
//****************************************************************************************************************
//fce pro zjisteni poctu parametru funkce, aby se vedelo kolik toho ulozi na zasobnik. Plati jen pro lokalni fce
//****************************************************************************************************************
int CEmit::functionToStackChange(FUNCTION* function)
{
	int stackchange = 0;
	char* str = function->signature;
	for (str; *str != '('; str++);	//preskakuj znaky dokud nenajdes (
	str++;					//posun na dalsi znak, prvni cislice

    char num[128];
	int index = 0;
	while (*str != ')')		//cyklus ktery uklada znaky (musi to byt cislice) do bufferu dokud nenajde )
	{
		num[index] = *str++;
		index++;
	}
	num[index] = 0;

	stackchange -= atoi(num);		//prevedeni retezce ktery obsahuje pocet parametru fce na cislo

	if (function->returns_value)
			stackchange++;

	return stackchange;
}
//****************************************************************************************************************
//vrati maximalni velikost zasobniku pro danou funkci
//
//V e funkci se mohou vyskytovat aritmeticjke operace, volani funkci a pri tom se musi operandy ukladat na zasobnik
//Tato funkce spocita kolik hodnot bude v zasobniku maximalne pritomno pri vykonavani dane funkce. 
//Uvedem si priklad. Budeme mit treba funkci ktera jen vola funcki max(1,2,3,4). na zasobnik se musi ulozit tyto
//ctyri argumenty: 1,2,3,4. Maximalni velikost asobniku bude 4. Tato hodnota je vyuzita ve virtualnim stroji ke zjisteni,
//zda muzeme volat a vykonat dalsi funkci aniz by doslo k preteceni, tj. preplneni zasobniku
//****************************************************************************************************************
void CEmit::GetMaxStackSize(CInstruction* code,int iCurrStackSize,int* iMaxStackSize)
{
	if (code)
	{
		//pokud sme instrukci este nekontrolovali
		if (!code->visited)
		{
			code->visited = 1;

			switch (code->kind)
			{
			case incCK:		//tyto instrukce nemeni vrchol zasobniku
			case decCK:
			case nopCK:
			case negCK:
			case labelCK:
				break;
			case lgotoCK:
				GetMaxStackSize(m_CurrLabels[code->val.gotoC].position,iCurrStackSize,iMaxStackSize);
				break;		//nemeni zasobnik
			case storeCK:	//pocinaje instrukci store, nasledujici instrukce snizuji vrchol zasobniku 0 1		
			case popCK:		//napriklad aritmeticke instrukce add,sub,div,mul vybiraji ze zasobniku dva operandy
			case shlCK:		//a jeden tam ulozi, ve vysledku se tak vrchol zasobniku snizi o 1 oproti predchozimu stavu
			case shrCK:
			case mulCK:
			case modCK:
			case subCK:
			case divCK:
			case addCK:
			case orCK:
			case andCK:
				iCurrStackSize--;
				break;
			case ifeqCK:			
				iCurrStackSize--;		//podminene skoky vsechny ve vyslekdu snizuji vrchol zasobniku o 1
										//ale u skoku pokracujeme zkoumanim kodu ktery by se porvedl pokud by podminka platila
				GetMaxStackSize(m_CurrLabels[code->val.ifeqC].position,iCurrStackSize,iMaxStackSize);
				break;
			case ifneCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.ifneC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpeqCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpeqC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpgtCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpgtC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpltCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpltC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpleCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpleC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpgeCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpgeC].position,iCurrStackSize,iMaxStackSize);
				break;
			case if_cmpneCK:
				iCurrStackSize--;
				GetMaxStackSize(m_CurrLabels[code->val.if_cmpneC].position,iCurrStackSize,iMaxStackSize);
				break;
			case vreturnCK:			//pokud narazime na return, ukocnime vypocet
			case nreturnCK:
				return;
			case loadCK:			//nasledujici instrukce zvysuji vrchol zasobniku o 1
			case ldc_intCK:			//jako napriklad instrukce pro nacteni celociselne, desetinne
			case ldc_stringCK:		//nebo retezcove konstanty na zasobnik
			case ldc_doubleCK:
			case dupCK:
				iCurrStackSize++;
				//soucasna vyska zasobniku muze byt mensi nez maximalni hodnota nalezena drive,
				//musime si pamatovat tu nejevsti. maximalni vyska zasobniku se uklada jen pokud narazime na
				//instrukci ktera ukazatel vrcholu zasobniku zvysuje
				*iMaxStackSize = max(iCurrStackSize,*iMaxStackSize);
				break;			
			case ecallCK:
				//volani funkce ze zasobniku uvolni parametry, vrchol zasobniku bude snizen o pocet zadanych parametru
				//a pokud funkce vraci hodnotu, bude tato hodnota na vrcholu zasobniku po provedeni fce
				//a tudiz se zvysi zasobnik o 1
				iCurrStackSize -= code->val.ecallC.arguments;
				if (code->val.ecallC.function->type->kind != VOID_TYPE)
					iCurrStackSize++;
				*iMaxStackSize = max(iCurrStackSize,*iMaxStackSize);
				break;			
			case lcallCK:
				iCurrStackSize -= functionToStackChange(code->val.lcallC);
				if (code->val.ecallC.function->returns_value == true)
					iCurrStackSize++;
				*iMaxStackSize = max(iCurrStackSize,*iMaxStackSize);
				break;			
			}
		}
		GetMaxStackSize(code->next,iCurrStackSize,iMaxStackSize);
	}
}
//****************************************************************************************************************
//jenom vypis kodu do souboru v zavislosti na instrukci
//
//Konstanty pro instrukce jsou definovany v opcodes.h
//****************************************************************************************************************
void CEmit::processCode(CInstruction* code)
{
	if (code != NULL)
	{
		fprintf(m_assemblyFile," ");
		switch (code->kind)
		{
		case nopCK:
			fprintf(m_assemblyFile,instruction_nop);
			break;
		case mulCK:
			fprintf(m_assemblyFile,instruction_mul);
			break;
		case negCK:
			fprintf(m_assemblyFile,instruction_neg);
			break;
		case modCK:
			fprintf(m_assemblyFile,instruction_mod);
			break;
		case subCK:
			fprintf(m_assemblyFile,instruction_sub);
			break;
		case divCK:
			fprintf(m_assemblyFile,instruction_div);
			break;
		case addCK:
			fprintf(m_assemblyFile,instruction_add);
			break;
		case labelCK:
			processLabel(code->val.labelC);
			fprintf(m_assemblyFile,instruction_label);
			break;
		case lgotoCK:
			fprintf(m_assemblyFile,"%s ",instruction_lgoto);
			processLabel(code->val.gotoC);
			break;
		case ifeqCK:
			fprintf(m_assemblyFile,"%s ",instruction_ifeq);
			processLabel(code->val.ifeqC);
			break;
		case ifneCK:
			fprintf(m_assemblyFile,"%s ",instruction_ifne);
			processLabel(code->val.ifneC);
			break;
		case if_cmpeqCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmpeq);
			processLabel(code->val.if_cmpeqC);
			break;
		case if_cmpgtCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmpgt);
			processLabel(code->val.if_cmpgtC);
			break;
		case if_cmpltCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmplt);
			processLabel(code->val.if_cmpltC);
			break;
		case if_cmpleCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmple);
			processLabel(code->val.if_cmpleC);
			break;
		case if_cmpgeCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmpge);
			processLabel(code->val.if_cmpgeC);
			break;
		case if_cmpneCK:
			fprintf(m_assemblyFile,"%s ",instruction_if_cmpne);
			processLabel(code->val.if_cmpneC);
			break;
		case nreturnCK:
			fprintf(m_assemblyFile,instruction_nreturn);
			break;
		case vreturnCK:
			fprintf(m_assemblyFile,instruction_vreturn);
			break;
		case loadCK:
			fprintf(m_assemblyFile,"%s %i",instruction_load,code->val.loadC);
			break;
		case storeCK:
			fprintf(m_assemblyFile,"%s %i",instruction_store,code->val.storeC);
			break;
		case dupCK:
			fprintf(m_assemblyFile,instruction_dup);
			break;
		case popCK:
			fprintf(m_assemblyFile,instruction_pop);
			break;
		case ldc_intCK:
			fprintf(m_assemblyFile,"%s %i",instruction_ldc_int,code->val.ldc_intC);
			break;
		case ldc_stringCK:
			fprintf(m_assemblyFile,"%s \"%s\"",instruction_ldc_string,code->val.ldc_stringC);
			break;
		case ldc_doubleCK:
			fprintf(m_assemblyFile,"%s %f",instruction_ldc_double,code->val.ldc_doubleC);
			break;
		case lcallCK:
			fprintf(m_assemblyFile,"%s %s",instruction_lcall,code->val.lcallC->signature);
			break;
		case ecallCK:
			fprintf(m_assemblyFile,"%s %s %i",instruction_ecall,code->val.ecallC.function->signature,code->val.ecallC.arguments);
			break;
		case shlCK:
			fprintf(m_assemblyFile,instruction_shl);
			break;
		case shrCK:
			fprintf(m_assemblyFile,instruction_shr);
			break;
		case incCK:
			fprintf(m_assemblyFile,instruction_inc);
			break;
		case decCK:
			fprintf(m_assemblyFile,instruction_dec);
			break;
		case orCK:
			fprintf(m_assemblyFile,instruction_or);
			break;
		case andCK:
			fprintf(m_assemblyFile,instruction_and);
			break;
		}

		fprintf(m_assemblyFile,"\n");
		processCode(code->next);
	}
}

/*rekurze stromem*/
//****************************************************************************************************************
//fce pro emitovani celeho skriptu
//****************************************************************************************************************
void CEmit::Process(SCRIPT* theScript,char* outputFile)
{
	//otevreni vystupniho souboru pro zapis
	m_assemblyFile = fopen(outputFile,"w");

	if (theScript->toplevels)
		processTOPLEVEL(theScript->toplevels);

	//zavreni vystupniho souboru
	fclose(m_assemblyFile);
}
//****************************************************************************************************************
//fce pro emitovani toplevelu
//****************************************************************************************************************
void CEmit::processTOPLEVEL(TOPLEVEL* toplevel)
{
	//emitovani funkce
	processFUNCTION(toplevel->function);

	//emitovani dalsich toplevelu
	if (toplevel->next)
		processTOPLEVEL(toplevel->next);
}
//****************************************************************************************************************
//fce pro emitovani funkce
//****************************************************************************************************************
void CEmit::processFUNCTION(FUNCTION* function)
{
	if (function->kind == localT)
	{
		//vypis zacatku funkce s jejim jmenem a podpisem
		fprintf(m_assemblyFile,"%s %s\n",token_function,function->signature);
	
		fprintf(m_assemblyFile,"%s %i\n",token_locals_limit,function->localsLimit);
		//nastavemi ukazatele na pole navesti pro danou funkci
		m_CurrLabels = function->labels;
		//pokud ma funkce kod v instrukcich
		if (function->opcodes != NULL)
		{
			int iMaxStack = 0;
			GetMaxStackSize(function->opcodes,0,&iMaxStack);
			fprintf(m_assemblyFile,"%s %i\n",token_stack_limit,iMaxStack);
			//vypsani celeho tela funkce v instrukcich jazyka
			processCode(function->opcodes);
		}

		//vypis konce funkce
		fprintf(m_assemblyFile,"%s\n\n",token_end_function);
	}
	if (function->kind == externT)
	{
		fprintf(m_assemblyFile,"%s \"%s\" %s %s\n",token_import,function->library,processTYPE(function->type),function->signature);
	}
}
//****************************************************************************************************************
//Zpracovani typu
//****************************************************************************************************************
char* CEmit::processTYPE(TYPE* type)
{
	switch (type->kind)
	{
	case intT:
		return token_type_int;
	case stringT:
		return token_type_string;
	case doubleT:
		return token_type_double;
	default:
		return token_type_void;
	}
}